//
//  WXKBookmarkWindowController_Metadata.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/09/11.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import "WXKBookmarkWindowController.h"


@implementation WXKBookmarkWindowController (Metadata)

- (void)managedObjectContextDidSave:(NSNotification *)notification
{
	NSDictionary *userInfo = [notification userInfo];
	
	NSSet           *insertedObjectsSet = [userInfo objectForKey:NSInsertedObjectsKey];
	NSSet           *updatedObjectsSet  = [userInfo objectForKey:NSUpdatedObjectsKey];
	NSSet           *deletedObjectsSet  = [userInfo objectForKey:NSDeletedObjectsKey];
	NSEnumerator    *enumerator;
	NSManagedObject *object;
	
	NSEntityDescription *bookmarkEntity    = [NSEntityDescription entityForName:@"Bookmark" inManagedObjectContext:[self managedObjectContext]];
	NSString            *metadataDirectory = [[self class] metadataDirectory];
	NSFileManager       *fileManager       = [NSFileManager defaultManager];
	NSArray             *keys              = [NSArray arrayWithObjects:@"title", @"url", nil];
	
	enumerator = [deletedObjectsSet objectEnumerator];
	while (object = [enumerator nextObject]) {
		if ([object entity] == bookmarkEntity) {
			NSString *absoluteString    = [[[object objectID] URIRepresentation] absoluteString];
			NSString *lastPathComponent = [absoluteString lastPathComponent];
			if (lastPathComponent == nil) continue;
			
			NSString *filename = [metadataDirectory stringByAppendingPathComponent:[lastPathComponent stringByAppendingPathExtension:@"kyoponbookmark"]];
			
			if ([fileManager removeFileAtPath:filename handler:nil] == NO) {
				NSLog(@"remove failed: %@", object);
			}
		}
	}
	
	enumerator = [insertedObjectsSet objectEnumerator];
	while (object = [enumerator nextObject]) {
		if ([object entity] == bookmarkEntity) {
			NSString *absoluteString    = [[[object objectID] URIRepresentation] absoluteString];
			NSString *lastPathComponent = [absoluteString lastPathComponent];
			if (lastPathComponent == nil) continue;
			
			NSString     *filename   = [lastPathComponent stringByAppendingPathExtension:@"kyoponbookmark"];
			NSString     *path       = [metadataDirectory stringByAppendingPathComponent:filename];
			NSDictionary *dictionary = [object dictionaryWithValuesForKeys:keys];
			if ([dictionary writeToFile:path atomically:YES] == NO) {
				NSLog(@"insert failed: %@", object);
			}
		}
	}
	
	enumerator = [updatedObjectsSet objectEnumerator];
	while (object = [enumerator nextObject]) {
		if ([object entity] == bookmarkEntity) {
			NSString *absoluteString    = [[[object objectID] URIRepresentation] absoluteString];
			NSString *lastPathComponent = [absoluteString lastPathComponent];
			if (lastPathComponent == nil) continue;
			
			NSString     *filename   = [lastPathComponent stringByAppendingPathExtension:@"kyoponbookmark"];
			NSString     *path       = [metadataDirectory stringByAppendingPathComponent:filename];
			NSDictionary *dictionary = [object dictionaryWithValuesForKeys:keys];
			if ([dictionary writeToFile:path atomically:YES] == NO) {
				NSLog(@"update failed: %@", object);
			}
		}
	}
}

@end
